"""
 *   BSD LICENSE
 *
 *   Copyright (c) 2021 Samsung Electronics Co., Ltd.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Samsung Electronics Co., Ltd. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""

def get_qpair_latency_profile(client, nqn, cid, qid):
    """Get latency profile information for an NVMe-oF subsystem/

    Args:
        nqn: Subsystem NQN
        cid: Controller ID
        qid: Qpair ID

    Returns:
	    Qpair latency profile details
    """

    params = {'nqn': nqn,
              'cid': cid,
              'qid': qid}

    return client.call('dss_get_latency_profile', params)

def reset_ustat_counters(client, nqn):
	"""Reset ustat counters for an NVMEoF subsystem

	Args:
		nqn: Subsystem NQN

	Returns:
		true when reset is done
	"""

	params = {'nqn': nqn}

	return client.call('dss_reset_ustat_counters', params)

def dss_set_io_stall_timeout(client, timeout):
	"""Set timeout for IO stall if enabled in config

	Args:
		timeout: timeout to set in seconds

	Returns:
		true when timeout is set
	"""

	params = {'timeout': timeout}

	return client.call('dss_stall_io', params)

def dss_rdb_compact(client, nqn, get_status=False):
	"""Initialte or get status of compaction for rdb block devices in an NVMEoF subsystem

	Args:
		nqn: Subsystem NQN
        get_status: Get only current status (True) or try to start compaction (False)

	Returns:
		true compaction is started
	"""

	params = {'nqn': nqn,
              'get_status': get_status}

	return client.call('dss_rdb_compact', params)
